local function name_entities(surface, names, position, area)
  -- area is range, can upgrade later to box
  for _, name in pairs(names) do
    for _, entity in pairs(surface.find_entities_filtered{
      area= {{position.x -area, position.y -area},{position.x +area, position.y +area}},
      name=name,
    }) do
		log("found: "..entity.name)
      --entity.destroy()
    end
  end
end

local function crystal_reactor_setup (entity)

  global.crystal_reactor = global.crystal_reactor or  {}
  global.crystal_reactor_next_id = global.crystal_reactor_next_id or 1

  local generator = entity.surface.find_entities_filtered{
    name="crystal-reactor-generator",
    position=entity.position
  }[1]
  if not generator then
    generator = entity.surface.create_entity{
      name="crystal-reactor-generator",
      position={entity.position.x, entity.position.y},
      direction=entity.direction,
      force=entity.force
    }
  end
  local struct = {
    struct_id = global.crystal_reactor_next_id,
    reactor = entity,
    generator = generator
  }
  global.crystal_reactor[entity.unit_number] = struct
  global.crystal_reactor_next_id = global.crystal_reactor_next_id + 1
end


--script.on_event('handyhands-decrease', function(event) change(event, false) end)

local function on_tick(event)
  if global.crystal_reactor and game.tick % 60 == 0 then
    for _, struct in pairs(global.crystal_reactor) do
      if not struct.reactor.valid or not struct.generator.valid then global.crystal_reactor[_] = nil return end
      -- fill the burner water slot
      struct.reactor.fluidbox[1] = {type = "water", amount = struct.reactor.fluidbox.get_capacity(1), temperature = 15}
      -- get the steam
      local reactor_steam = struct.reactor.fluidbox[2] and struct.reactor.fluidbox[2].amount or 0
      local generator_steam = (struct.generator.fluidbox and struct.generator.fluidbox[1]) and struct.generator.fluidbox[1].amount or 0
      -- buffer transfer to stop stutter
      local to_transfer = math.min(reactor_steam, struct.generator.fluidbox.get_capacity(1) - generator_steam)
      if to_transfer > 0 then
        struct.reactor.fluidbox[2] = {type = "steam", amount = reactor_steam - to_transfer, temperature = 165}
        struct.generator.fluidbox[1] = {type = "steam", amount = generator_steam + to_transfer, temperature = 165}
		log("Tick:"..game.tick.." transfering")
      end
    end
  end
end

script.on_event(defines.events.on_tick, on_tick)

local function on_entity_created(event)
  if event.created_entity and event.created_entity.valid then
    local entity = event.created_entity
	if entity.name == "omni-inserter" then
		event.created_entity.set_filter(1,"omnite")
		event.created_entity.inserter_stack_size_override=255
		event.created_entity.operable = false
	elseif entity.name == "crystal-reactor" then
		crystal_reactor_setup(entity)
    end
  end
end
script.on_event(defines.events.on_built_entity, on_entity_created)
script.on_event(defines.events.on_robot_built_entity, on_entity_created)

local function remove_entities(surface, names, position, area)
  -- area is range, can upgrade later to box
  for _, name in pairs(names) do
    for _, entity in pairs(surface.find_entities_filtered{
      area= {{position.x -area, position.y -area},{position.x +area, position.y +area}},
      name=name,
    }) do
      entity.destroy()
    end
  end
end

local function on_entity_removed(event)
  if event.entity and event.entity.valid then
    local entity = event.entity
    if entity.name == "crystal-reactor" then
      remove_entities(entity.surface, {"crystal-reactor-generator"}, entity.position, 2)
    end
  end
end

local function on_player_rotated_entity(event)
  if event.entity and event.entity.valid then
    local entity = event.entity
    if entity.name == "crystal-reactor" then
        entity.direction = defines.direction.north
    end
  end
end

script.on_event(defines.events.on_player_rotated_entity, on_player_rotated_entity)

script.on_event(defines.events.on_entity_died, on_entity_removed)
script.on_event(defines.events.on_preplayer_mined_item, on_entity_removed)
script.on_event(defines.events.on_robot_pre_mined, on_entity_removed)
